unit UnitSmppOptions;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, AXmsCtrl_TLB;

type
  TFormSmppOptions = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    EditTimeout: TEdit;
    ComboVersion: TComboBox;
    EditKeepAlive: TEdit;
    EditThroughput: TEdit;
    EditServiceType: TEdit;
    EditSystemType: TEdit;
    ComboCharset: TComboBox;
    EditAddressRange: TEdit;
    EditSourceAddress: TEdit;
    ComboSourceTON: TComboBox;
    ComboSourceNPI: TComboBox;
    ComboDestinationTON: TComboBox;
    ComboDestinationNPI: TComboBox;
    ButtonOK: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ButtonOKClick(Sender: TObject);
  private
    objConstants    : ISmsConstants;
  public
    SystemSourceNPI       : Integer;
    SystemSourceTON       : Integer;
    SystemDestinationNPI  : Integer;
    SystemDestinationTON  : Integer;
    SystemVersion         : Integer;
    ServerTimeout         : Integer;
    ServerKeepAlive       : Integer;
    SystemThroughput      : Integer;
    SystemCharset         : Integer;

    SystemSourceAddress   : String;
    AddressRange          : String;
    ServiceType           : String;
  end;

var
  FormSmppOptions: TFormSmppOptions;

implementation

{$R *.dfm}

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmppOptions.FormCreate(Sender: TObject);
begin
  objConstants  := TSmsConstants.Create(Application).DefaultInterface;

  ComboSourceTON.Items.Add ( '0 - Default' );
  ComboSourceTON.Items.Add ( '1 - International Number' );
  ComboSourceTON.Items.Add ( '2 - National Number' );
  ComboSourceTON.Items.Add ( '3 - Network Specific Number' );
  ComboSourceTON.Items.Add ( '4 - Subscriber Number' );
  ComboSourceTON.Items.Add ( '5 - Alphanumeric Number' );
  ComboSourceTON.Items.Add ( '6 - Abbreviated Number' );
  ComboSourceTON.Items.Add ( '7 - Reserved Number' );

  ComboSourceTON.ItemIndex  := SystemSourceTON;

  ComboSourceNPI.Items.Add ( '0 - Default' );
  ComboSourceNPI.Items.Add ( '1 - ISDN/Telephone' );
  ComboSourceNPI.Items.Add ( '2 - Reserved' );
  ComboSourceNPI.Items.Add ( '3 - Data');
  ComboSourceNPI.Items.Add ( '4 - Telex' );
  ComboSourceNPI.Items.Add ( '5 - Reserved' );
  ComboSourceNPI.Items.Add ( '6 - Land Mobile' );
  ComboSourceNPI.Items.Add ( '7 - Reserved' );
  ComboSourceNPI.Items.Add ( '8 - National' );
  ComboSourceNPI.Items.Add ( '9 - Private' );

  ComboSourceNPI.ItemIndex  := SystemSourceNPI;

  ComboDestinationTON.Items.Add ( '0 - Default' );
  ComboDestinationTON.Items.Add ( '1 - International Number' );
  ComboDestinationTON.Items.Add ( '2 - National Number' );
  ComboDestinationTON.Items.Add ( '3 - Network Specific Number' );
  ComboDestinationTON.Items.Add ( '4 - Subscriber Number' );
  ComboDestinationTON.Items.Add ( '5 - Alphanumeric Number' );
  ComboDestinationTON.Items.Add ( '6 - Abbreviated Number' );
  ComboDestinationTON.Items.Add ( '7 - Reserved Number' );

  ComboDestinationTON.ItemIndex := SystemDestinationTON;

  ComboDestinationNPI.Items.Add ( '0 - Default' );
  ComboDestinationNPI.Items.Add ( '1 - ISDN/Telephone' );
  ComboDestinationNPI.Items.Add ( '2 - Reserved' );
  ComboDestinationNPI.Items.Add ( '3 - Data');
  ComboDestinationNPI.Items.Add ( '4 - Telex' );
  ComboDestinationNPI.Items.Add ( '5 - Reserved' );
  ComboDestinationNPI.Items.Add ( '6 - Land Mobile' );
  ComboDestinationNPI.Items.Add ( '7 - Reserved' );
  ComboDestinationNPI.Items.Add ( '8 - National' );
  ComboDestinationNPI.Items.Add ( '9 - Private' );

  ComboDestinationNPI.ItemIndex := SystemDestinationNPI;

  ComboVersion.Items.Add ( 'v 3.3' );
  ComboVersion.Items.Add ( 'v 3.4' );
  ComboVersion.Items.Add ( 'v 5.0' );

  case SystemVersion of
  33: ComboVersion.ItemIndex := 0;
  34: ComboVersion.ItemIndex := 1;
  50: ComboVersion.ItemIndex := 2;
  end;

  ComboCharset.Items.Add ( 'SMSC Default' );
  ComboCharset.Items.Add ( 'GSM (IA5)' );
  ComboCharset.Items.Add ( 'ASCII' );
  ComboCharset.Items.Add ( 'Latin (ISO8859-1)' );
  ComboCharset.Items.Add ( 'JIS' );
  ComboCharset.Items.Add ( 'Cyrillic' );
  ComboCharset.Items.Add ( 'Hebrew' );
  ComboCharset.Items.Add ( 'Japanese' );
  ComboCharset.Items.Add ( 'Greek' );

  ComboCharset.ItemIndex := SystemCharset;

  EditTimeout.Text      := IntToStr ( ServerTimeout );
  EditKeepalive.Text    := IntToStr ( ServerKeepAlive );
  EditThroughput.Text   := IntToStr ( SystemThroughput );
  EditServiceType.Text  := ServiceType;
  EditAddressRange.Text := AddressRange;
  EditSourceAddress.Text:= SystemSourceAddress;
  
end;

{////////////////////////////////////////////////////////////////////////////////}

procedure TFormSmppOptions.ButtonOKClick(Sender: TObject);
begin
  ServerTimeout         := StrToInt ( EditTimeout.Text );
  ServerKeepAlive       := StrToInt ( EditKeepAlive.Text );
  SystemThroughput      := StrToInt ( EditThroughput.Text );

  ServiceType           := EditServiceType.Text;
  AddressRange          := EditAddressRange.Text;
  SystemSourceAddress   := EditSourceAddress.Text;

  SystemCharset         := ComboCharset.ItemIndex;
  SystemSourceTON       := ComboSourceTON.ItemIndex;
  SystemSourceNPI       := ComboSourceNPI.ItemIndex;
  SystemDestinationTON  := ComboDestinationTON.ItemIndex;
  SystemDestinationNPI  := ComboDestinationNPI.ItemIndex;

  case ComboVersion.ItemIndex of
  0:  SystemVersion     := objConstants.asSMPPVERSION_33;
  1:  SystemVersion     := objConstants.asSMPPVERSION_34;
  2:  SystemVersion     := objConstants.asSMPPVERSION_50;
  end;
  
  ModalResult:= mrOK;
end;

{////////////////////////////////////////////////////////////////////////////////}

end.
